package com.lwtek.demo.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.lwtek.demo.R;
import com.lwtek.demo.databinding.ItemDeviceListBinding;
import com.lwtek.scanner.core.ScannerDevice;

import java.util.ArrayList;
import java.util.List;

public class DevicesViewAdapter extends RecyclerView.Adapter<DevicesViewAdapter.ViewHolder> {

    private final Context context;

    private final List<ScannerDevice> scannerList = new ArrayList<>();
    private final List<ScannerDevice> scannerBondedList = new ArrayList<>();

    private int currentPosition = -1;

    public DevicesViewAdapter(Context context) {
        this.context = context;
    }

    public void add(ScannerDevice scanner) {
        if (!scannerList.contains(scanner)) {
            scannerList.add(0, scanner);
            notifyDataSetChanged();
        }
    }

    public void addBonded(ScannerDevice scanner) {
        if (!scannerBondedList.contains(scanner)) {
            scannerBondedList.add(0, scanner);
            notifyDataSetChanged();
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    public void clear() {
        currentPosition = -1;
        scannerList.clear();
        scannerBondedList.clear();
        notifyDataSetChanged();
    }

    public ScannerDevice getCurrent() {
        if (currentPosition == -1) {
            return null;
        } else {
            int size = scannerBondedList.size();
            if (currentPosition > size - 1) {
                return scannerList.get(currentPosition - size);
            } else {
                return scannerBondedList.get(currentPosition);
            }
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ItemDeviceListBinding binding = ItemDeviceListBinding.inflate(LayoutInflater.from(parent.getContext()), parent, false);
        return new ViewHolder(binding);
    }

    @Override
    public int getItemCount() {
        return scannerBondedList.size() + scannerList.size();
    }

    @SuppressLint("NotifyDataSetChanged")
    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        ScannerDevice scanner = position < scannerBondedList.size() ? scannerBondedList.get(position) : scannerList.get(position - scannerBondedList.size());
        ItemDeviceListBinding binding = holder.binding;
        binding.deviceName.setText(scanner.getName());
        binding.deviceAddress.setText(scanner.getAddress());
        binding.title.setVisibility(View.GONE);
        if (position == 0 && !scannerBondedList.isEmpty()) {
            binding.title.setVisibility(View.VISIBLE);
            binding.title.setText("Already bound");
        } else if (position == scannerBondedList.size()) {
            binding.title.setVisibility(View.VISIBLE);
            binding.title.setText("scanning");
        }
        if (currentPosition == position) {
            binding.deviceName.setTextColor(ContextCompat.getColor(context, R.color.white));
            binding.deviceAddress.setTextColor(ContextCompat.getColor(context, R.color.white));
            binding.content.setBackgroundResource(R.color.blue);
        } else {
            binding.deviceName.setTextColor(ContextCompat.getColor(context, R.color.black));
            binding.deviceAddress.setTextColor(ContextCompat.getColor(context, R.color.black));
            binding.content.setBackgroundResource(R.color.white);
        }
        binding.content.setOnClickListener(v -> {
            currentPosition = (currentPosition != position ? position : -1);
            notifyDataSetChanged();
        });
    }

    static class ViewHolder extends RecyclerView.ViewHolder {

        ItemDeviceListBinding binding;

        public ViewHolder(@NonNull ItemDeviceListBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
        }

    }

}